#ifndef __RPC_ERROR_H
#define __RPC_ERROR_H




////////////////////////////////////////////////////////////////////////////////
// RPC TASK's ERROR AND DIAGNOSIS - CODES
////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_RPC_TASK_COMMAND_INVALID
//
// MessageText:
//
//  Received packet with invalid command.
//
#define TLR_E_RPC_TASK_COMMAND_INVALID   ((TLR_RESULT)0xC02E0001L)

// RPC DIAGNOSIS - CODES
//
// MessageId: TLR_DIAG_E_RPC_TASK_CLIENT_RESOURCE_INIT_FAILED
//
// MessageText:
//
//  Initiating CLRPC-Client failed. (CLRPC_Client_Initialize())
//
#define TLR_DIAG_E_RPC_TASK_CLIENT_RESOURCE_INIT_FAILED ((TLR_RESULT)0xC02E0010L)

//
// MessageId: TLR_DIAG_E_RPC_TASK_SERVER_RESOURCE_INIT_FAILED
//
// MessageText:
//
//  Initiating CLRPC-Server failed (CLRPC_Server_Initialize()).
//
#define TLR_DIAG_E_RPC_TASK_SERVER_RESOURCE_INIT_FAILED ((TLR_RESULT)0xC02E0011L)

//
// MessageId: TLR_DIAG_E_RPC_TASK_EPMAP_RESOURCE_INIT_FAILED
//
// MessageText:
//
//  Initiating CLRPC-Endpoint-Mapper failed (CLRPC_Mapper_Initialize()).
//
#define TLR_DIAG_E_RPC_TASK_EPMAP_RESOURCE_INIT_FAILED ((TLR_RESULT)0xC02E0012L)

//
// MessageId: TLR_DIAG_E_RPC_TASK_INIT_LOCAL_CREATE_QUE_FAILED
//
// MessageText:
//
//  Creating message queue failed.
//
#define TLR_DIAG_E_RPC_TASK_INIT_LOCAL_CREATE_QUE_FAILED ((TLR_RESULT)0xC02E0013L)

//
// MessageId: TLR_DIAG_E_RPC_TASK_INIT_REMOTE_IDENT_EDD_FAILED
//
// MessageText:
//
//  Identifying Drv_EDD failed.
//
#define TLR_DIAG_E_RPC_TASK_INIT_REMOTE_IDENT_EDD_FAILED ((TLR_RESULT)0xC02E0014L)

//
// MessageId: TLR_DIAG_E_RPC_TASK_INIT_REMOTE_GET_MAC_FAILED
//
// MessageText:
//
//  Getting the MAC address failed.
//
#define TLR_DIAG_E_RPC_TASK_INIT_REMOTE_GET_MAC_FAILED ((TLR_RESULT)0xC02E0015L)

//
// MessageId: TLR_DIAG_E_RPC_TASK_INIT_REMOTE_IDENT_TCPUDP_QUE_FAILED
//
// MessageText:
//
//  Getting queue handle to TCPIP-Task failed.
//
#define TLR_DIAG_E_RPC_TASK_INIT_REMOTE_IDENT_TCPUDP_QUE_FAILED ((TLR_RESULT)0xC02E0016L)

// GENERIC RPC ERROR - CODES
//
// MessageId: TLR_E_RPC_STATUS
//
// MessageText:
//
//  Generic RPC-error code. See Profinet-status code for details.
//
#define TLR_E_RPC_STATUS                 ((TLR_RESULT)0xC02E0100L)

//
// MessageId: TLR_E_RPC_CONNECT_OUT_OF_MEMORY
//
// MessageText:
//
//  There was not enough memory allocated to receive the whole IO-Device's Connect-Response PDU. Most likely it containes a very large ModuleDiff-Block.
//
#define TLR_E_RPC_CONNECT_OUT_OF_MEMORY  ((TLR_RESULT)0xC02E0101L)

//
// MessageId: TLR_E_RPC_FATAL_ERROR_CLB_ALREADY_REGISTERED
//
// MessageText:
//
//  The fatal error callback function is already registered.
//
#define TLR_E_RPC_FATAL_ERROR_CLB_ALREADY_REGISTERED ((TLR_RESULT)0xC02E0102L)

//
// MessageId: TLR_E_CLRPC_PACKET_SEND_FAILED
//
// MessageText:
//
//  Error while sending internal message to another task.
//
#define TLR_E_CLRPC_PACKET_SEND_FAILED   ((TLR_RESULT)0xC02E0200L)

//
// MessageId: TLR_E_CLRPC_TIMER_OUT_OF_MEMORY
//
// MessageText:
//
//  Creating a TLR-Timer-packet in RPC task failed due to insufficient memory.
//
#define TLR_E_CLRPC_TIMER_OUT_OF_MEMORY  ((TLR_RESULT)0xC02E0201L)

//
// MessageId: TLR_E_CLRPC_REF_COUNTER_INVALID
//
// MessageText:
//
//  The reference counter value is invalid.
//
#define TLR_E_CLRPC_REF_COUNTER_INVALID  ((TLR_RESULT)0xC02E0202L)

//
// MessageId: TLR_E_CLRPC_INVALID_PORT_HANDLE
//
// MessageText:
//
//  The port handle is invalid.
//
#define TLR_E_CLRPC_INVALID_PORT_HANDLE  ((TLR_RESULT)0xC02E0203L)

//
// MessageId: TLR_E_CLRPC_TIMER_ALREADY_ACTIVE
//
// MessageText:
//
//  The soft timer is already active (expected inactive).
//
#define TLR_E_CLRPC_TIMER_ALREADY_ACTIVE ((TLR_RESULT)0xC02E0204L)

// RPC ENDPOINT - MAPPER
//
// MessageId: TLR_E_CLRPC_MAPPER_INIT_FAILED
//
// MessageText:
//
//  The parameter "uiMaxReg" (maximum amount of RPC-mapper registrations) is invalid in CLRPC_EPMap_Initialize().
//
#define TLR_E_CLRPC_MAPPER_INIT_FAILED   ((TLR_RESULT)0xC02E0300L)

//
// MessageId: TLR_E_CLRPC_MAPPER_RESOURCE_LIMIT_EXCEEDED
//
// MessageText:
//
//  The requested Endpoint-Mapper index is invalid.
//
#define TLR_E_CLRPC_MAPPER_RESOURCE_LIMIT_EXCEEDED ((TLR_RESULT)0xC02E0301L)

//
// MessageId: TLR_E_CLRPC_MAPPER_RESOURCE_OUT_OF_MEMORY
//
// MessageText:
//
//  Insufficient memory for this request.
//
#define TLR_E_CLRPC_MAPPER_RESOURCE_OUT_OF_MEMORY ((TLR_RESULT)0xC02E0302L)

//
// MessageId: TLR_E_CLRPC_MAPPER_STATUS_INVALID
//
// MessageText:
//
//  The state of Endpoint-Mapper is invalid for this request.
//
#define TLR_E_CLRPC_MAPPER_STATUS_INVALID ((TLR_RESULT)0xC02E0303L)

//
// MessageId: TLR_E_CLRPC_MAPPER_STATUS_CLOSING
//
// MessageText:
//
//  The Endpoint-Mapper is waiting for close-confirmation and therefore its status isinvalid for this request.
//
#define TLR_E_CLRPC_MAPPER_STATUS_CLOSING ((TLR_RESULT)0xC02E0304L)

//
// MessageId: TLR_E_CLRPC_MAPPER_STATUS_UNKNOWN
//
// MessageText:
//
//  The status of Endpoint-Mapper is unknown.
//
#define TLR_E_CLRPC_MAPPER_STATUS_UNKNOWN ((TLR_RESULT)0xC02E0305L)

//
// MessageId: TLR_E_CLRPC_MAPPER_STATUS_CONFLICT
//
// MessageText:
//
//  The status of Endpoint-Mapper is not "Ready" and therefore request CLRPC_EPMap_Deregister_req() is invalid.
//
#define TLR_E_CLRPC_MAPPER_STATUS_CONFLICT ((TLR_RESULT)0xC02E0306L)

//
// MessageId: TLR_E_CLRPC_MAPPER_PARAMETER_FAILED
//
// MessageText:
//
//  Invalid parameter in CLRPC_EPMap_Register_req_Compare().
//
#define TLR_E_CLRPC_MAPPER_PARAMETER_FAILED ((TLR_RESULT)0xC02E0307L)

//
// MessageId: TLR_E_CLRPC_MAPPER_SERVER_REGISTERED
//
// MessageText:
//
//  CLRPC_EPMap_Deregister_req() is not allowed because at least one RPC-Server is registered to this Endpoint-Mapper.
//
#define TLR_E_CLRPC_MAPPER_SERVER_REGISTERED ((TLR_RESULT)0xC02E0308L)

// RPC SERVER
//
// MessageId: TLR_E_CLRPC_SERVER_INIT_FAILED
//
// MessageText:
//
//  An error occurred in CLRPC_Server_Initialize().
//
#define TLR_E_CLRPC_SERVER_INIT_FAILED   ((TLR_RESULT)0xC02E0400L)

//
// MessageId: TLR_E_CLRPC_SERVER_RESOURCE_LIMIT_EXCEEDED
//
// MessageText:
//
//  The maximum number of registered RPC-Servers is exceeded or the maximum number of outstanding requests is exceeded.
//
#define TLR_E_CLRPC_SERVER_RESOURCE_LIMIT_EXCEEDED ((TLR_RESULT)0xC02E0401L)

//
// MessageId: TLR_E_CLRPC_SERVER_TIMER_CREATE_FAILED
//
// MessageText:
//
//  Creating TLR-Timer for RPC-Server failed.
//
#define TLR_E_CLRPC_SERVER_TIMER_CREATE_FAILED ((TLR_RESULT)0xC02E0402L)

//
// MessageId: TLR_E_CLRPC_SERVER_NO_SERVER_REGISTERED
//
// MessageText:
//
//  There is no RPC-Server registered that could be deregistered (CLRPC_ServerDeregister_req()).
//
#define TLR_E_CLRPC_SERVER_NO_SERVER_REGISTERED ((TLR_RESULT)0xC02E0403L)

//
// MessageId: TLR_E_CLRPC_SERVER_RESOURCE_OUT_OF_MEMORY
//
// MessageText:
//
//  Insufficient memory to create an instance of RPC-Server.
//
#define TLR_E_CLRPC_SERVER_RESOURCE_OUT_OF_MEMORY ((TLR_RESULT)0xC02E0404L)

//
// MessageId: TLR_E_CLRPC_SERVER_MAPPER_HANDLE_INVALID
//
// MessageText:
//
//  The handle to Endpoint-Mapper in CLRPC_ServerRegister_req() is invalid.
//
#define TLR_E_CLRPC_SERVER_MAPPER_HANDLE_INVALID ((TLR_RESULT)0xC02E0405L)

//
// MessageId: TLR_E_CLRPC_SERVER_MAPPER_STATUS_INVALID
//
// MessageText:
//
//  The status of Endpoint-Mapper in CLRPC_ServerRegister_req() is invalid.
//
#define TLR_E_CLRPC_SERVER_MAPPER_STATUS_INVALID ((TLR_RESULT)0xC02E0406L)

//
// MessageId: TLR_E_CLRPC_SERVER_HANDLE_INVALID
//
// MessageText:
//
//  The handle to RPC-Server instance is invalid.
//
#define TLR_E_CLRPC_SERVER_HANDLE_INVALID ((TLR_RESULT)0xC02E0407L)

//
// MessageId: TLR_E_CLRPC_SERVER_OBJECT_REGISTERED
//
// MessageText:
//
//  There is at least one object registered to RPC-Server instance. CLRPC_ServerDeregister_req() can not proceed.
//
#define TLR_E_CLRPC_SERVER_OBJECT_REGISTERED ((TLR_RESULT)0xC02E0408L)

//
// MessageId: TLR_E_CLRPC_SERVER_PARAM_RECV_INVALID
//
// MessageText:
//
//  Invalid parameter "ulMaxRecv" in request-packet in CLRPC_ServerRegister_req().
//
#define TLR_E_CLRPC_SERVER_PARAM_RECV_INVALID ((TLR_RESULT)0xC02E0409L)

//
// MessageId: TLR_E_CLRPC_SERVER_PARAM_SEND_INVALID
//
// MessageText:
//
//  Invalid parameter "ulMaxSend" in request-packet in CLRPC_ServerRegister_req().
//
#define TLR_E_CLRPC_SERVER_PARAM_SEND_INVALID ((TLR_RESULT)0xC02E040AL)

//
// MessageId: TLR_E_CLRPC_SERVER_ELEMENT_INVALID
//
// MessageText:
//
//  Invalid RPC-Server element "ptElem". Internal RPC-Error.
//
#define TLR_E_CLRPC_SERVER_ELEMENT_INVALID ((TLR_RESULT)0xC02E040BL)

//
// MessageId: TLR_E_CLRPC_SERVER_REQUEST_CANCELED
//
// MessageText:
//
//  This RPC-Request was cancled.
//
#define TLR_E_CLRPC_SERVER_REQUEST_CANCELED ((TLR_RESULT)0xC02E040CL)

//
// MessageId: TLR_E_CLRPC_SERVER_STATE_INVALID
//
// MessageText:
//
//  The state of RPC server is invalid for this request.
//
#define TLR_E_CLRPC_SERVER_STATE_INVALID ((TLR_RESULT)0xC02E040DL)

//
// MessageId: TLR_E_CLRPC_SERVER_ACTIVITY_ALREADY_INITIALIZED
//
// MessageText:
//
//  The activity has already been initialized.
//
#define TLR_E_CLRPC_SERVER_ACTIVITY_ALREADY_INITIALIZED ((TLR_RESULT)0xC02E040EL)

//
// MessageId: TLR_E_CLRPC_SERVER_RECEIVED_INVALID_RSP_PACKET
//
// MessageText:
//
//  The RPC server received an invalid (unexpected) resposne packet.
//
#define TLR_E_CLRPC_SERVER_RECEIVED_INVALID_RSP_PACKET ((TLR_RESULT)0xC02E040FL)

// RPC OBJECT
//
// MessageId: TLR_E_CLRPC_OBJECT_RESOURCE_OUT_OF_MEMORY
//
// MessageText:
//
//  Insufficient memory to create an RPC-Object instance in CLRPC_ObjectRegister_req().
//
#define TLR_E_CLRPC_OBJECT_RESOURCE_OUT_OF_MEMORY ((TLR_RESULT)0xC02E0500L)

//
// MessageId: TLR_E_CLRPC_OBJECT_SERVER_HANDLE_INVALID
//
// MessageText:
//
//  The handle to RPC-Server instance in CLRPC_ObjectRegister_req() is invalid.
//
#define TLR_E_CLRPC_OBJECT_SERVER_HANDLE_INVALID ((TLR_RESULT)0xC02E0501L)

//
// MessageId: TLR_E_CLRPC_OBJECT_SERVER_STATUS_INVALID
//
// MessageText:
//
//  The status of RPC-Server instance in CLRPC_ObjectRegister_req() is invalid.
//
#define TLR_E_CLRPC_OBJECT_SERVER_STATUS_INVALID ((TLR_RESULT)0xC02E0502L)

//
// MessageId: TLR_E_CLRPC_OBJECT_HANDLE_INVALID
//
// MessageText:
//
//  The handle to RPC-Object instance in CLRPC_ObjectDeregister_req() is invalid.
//
#define TLR_E_CLRPC_OBJECT_HANDLE_INVALID ((TLR_RESULT)0xC02E0503L)

// RPC CLIENT
//
// MessageId: TLR_E_CLRPC_CLIENT_INIT_FAILED
//
// MessageText:
//
//  One of the parameters "uiMaxReg" or "uiMaxReq" in CLRPC_Client_Initialize() is invalid.
//
#define TLR_E_CLRPC_CLIENT_INIT_FAILED   ((TLR_RESULT)0xC02E0600L)

//
// MessageId: TLR_E_CLRPC_CLIENT_RESOURCE_LIMIT_EXCEEDED
//
// MessageText:
//
//  The maximum number of parallel RPC-Client instances in reached in CLRPC_ClientRegister_req()
//
#define TLR_E_CLRPC_CLIENT_RESOURCE_LIMIT_EXCEEDED ((TLR_RESULT)0xC02E0601L)

//
// MessageId: TLR_E_CLRPC_CLIENT_TIMER_CREATE_FAILED
//
// MessageText:
//
//  Creating the TLR-Timer for RPC-Client instance in CLRPC_ClientRegister_req() failed.
//
#define TLR_E_CLRPC_CLIENT_TIMER_CREATE_FAILED ((TLR_RESULT)0xC02E0602L)

//
// MessageId: TLR_E_CLRPC_CLIENT_RESOURCE_OUT_OF_MEMORY
//
// MessageText:
//
//  Insufficient memory for this request.
//
#define TLR_E_CLRPC_CLIENT_RESOURCE_OUT_OF_MEMORY ((TLR_RESULT)0xC02E0603L)

//
// MessageId: TLR_E_CLRPC_CLIENT_MAPPER_STATUS_INVALID
//
// MessageText:
//
//  The state of RPC Client is invalid for this request.
//
#define TLR_E_CLRPC_CLIENT_MAPPER_STATUS_INVALID ((TLR_RESULT)0xC02E0604L)

//
// MessageId: TLR_E_CLRPC_CLIENT_HANDLE_INVALID
//
// MessageText:
//
//  The handle to RPC-Client instance is invalid.
//
#define TLR_E_CLRPC_CLIENT_HANDLE_INVALID ((TLR_RESULT)0xC02E0605L)

//
// MessageId: TLR_E_CLRPC_CLIENT_REQUEST_LIMIT_EXCEEDED
//
// MessageText:
//
//  The maximum amount of outstanding RPC-Requests for this RPC-Clients instance is reached.
//
#define TLR_E_CLRPC_CLIENT_REQUEST_LIMIT_EXCEEDED ((TLR_RESULT)0xC02E0606L)

//
// MessageId: TLR_E_CLRPC_CLIENT_OPCODE_SEQUENCE
//
// MessageText:
//
//  RPC-Client instances can only connect to an IO-Device if there are no outstanding RPC-Requests. Currently at least one RPC-Request is outstanding.
//
#define TLR_E_CLRPC_CLIENT_OPCODE_SEQUENCE ((TLR_RESULT)0xC02E0607L)

//
// MessageId: TLR_E_CLRPC_CLIENT_DEREGISTERED
//
// MessageText:
//
//  The RPC-Client instance you tried to use is going to deregister right now. Aborting your Request !
//
#define TLR_E_CLRPC_CLIENT_DEREGISTERED  ((TLR_RESULT)0xC02E0608L)

//
// MessageId: TLR_E_CLRPC_CLIENT_ELEMENT_INVALID
//
// MessageText:
//
//  Invalid RPC-Client instance element "ptElem". Internal RPC-Error.
//
#define TLR_E_CLRPC_CLIENT_ELEMENT_INVALID ((TLR_RESULT)0xC02E0609L)

//
// MessageId: TLR_E_CLRPC_CLIENT_LONG_TIMEOUT_HIT
//
// MessageText:
//
//  The LONG timeout TLR-timer for an outstanding RPC-Request hit. Used internaly in RPC only.
//
#define TLR_E_CLRPC_CLIENT_LONG_TIMEOUT_HIT ((TLR_RESULT)0xC02E060AL)

//
// MessageId: TLR_E_CLRPC_CLIENT_RESPONSE_SEQUENCE_NUMBER
//
// MessageText:
//
//  Invalid sequence number in RPC-Message received by RPC-Client instance.
//
#define TLR_E_CLRPC_CLIENT_RESPONSE_SEQUENCE_NUMBER ((TLR_RESULT)0xC02E060BL)

//
// MessageId: TLR_E_CLRPC_CLIENT_CANCEL_TIMED_OUT
//
// MessageText:
//
//  Canceling a running request timed out. This RPC Client will no longer be usable.
//
#define TLR_E_CLRPC_CLIENT_CANCEL_TIMED_OUT ((TLR_RESULT)0xC02E060CL)

//
// MessageId: TLR_E_CLRPC_CLIENT_NO_REQUEST_PACKET
//
// MessageText:
//
//  The RPC Client did not have a packet to return.
//
#define TLR_E_CLRPC_CLIENT_NO_REQUEST_PACKET ((TLR_RESULT)0xC02E060DL)

//
// MessageId: TLR_E_CLRPC_CLIENT_RECV_REQ_WITH_UNEXPECTED_FLAG
//
// MessageText:
//
//  The RPC Client received a request with an unexpected Flag value.
//
#define TLR_E_CLRPC_CLIENT_RECV_REQ_WITH_UNEXPECTED_FLAG ((TLR_RESULT)0xC02E060EL)

//
// MessageId: TLR_E_CLRPC_CLIENT_ABORTED_BY_UNBIND_REQ
//
// MessageText:
//
//  The request was aborted because the RPC client was unbind.
//
#define TLR_E_CLRPC_CLIENT_ABORTED_BY_UNBIND_REQ ((TLR_RESULT)0xC02E060FL)

//
// MessageId: TLR_E_CLRPC_MAX_ACTIVITY_RESEND_RETRY_REACHED
//
// MessageText:
//
//  The maximum resend number was reached by the activity.
//
#define TLR_E_CLRPC_MAX_ACTIVITY_RESEND_RETRY_REACHED ((TLR_RESULT)0xC02E0610L)




#endif  //__RPC_ERROR_H

